# -----Web Services Security Sample Ruby Client-----
# ----------This code requires ruby 1.9.0----------

require 'digest'
require 'uri'
require 'net/http'
require 'time'

class LVWSClient

	def initialize (access_id = nil, secret_id = nil)
		@access_id = access_id
		@secret_id = secret_id
		@cookieHash = {}
		@uri = nil
	end
	
	attr_accessor :access_id
	attr_accessor :secret_id
	
  def SignRequest(req)
  
    t = Time.now.utc
    utcTime = t.xmlschema
    utcTime["T"] = " "
    
    # Set the x-ni-date header to UTC time with format
    # yyyy-mm-dd hh:mm:ssZ
    req.add_field("x-ni-date", utcTime.to_s)
    
    authentication = ""
    secretKeyMD5Hash = Digest::MD5.hexdigest(secret_id)
    hashDataString = req.method + req.path + utcTime.to_s + access_id + secretKeyMD5Hash
    
    if(((req.method == "POST") || (req.method == "PUT")))
      authentication = "NIWS2 "
      postDataMD5Hash = Digest::MD5.hexdigest(req.body)
      hashDataString += postDataMD5Hash
    else
      authentication = "NIWS "
    end
      
    hashDataString.force_encoding("UTF-8")
    sha256HashDataString = Digest::SHA256.digest(hashDataString)
    hashValue = [sha256HashDataString].pack 'm*'
    authentication += access_id + ":" + hashValue.to_s
    authentication.slice!(authentication.length - 1)
    
    # Set the x-ni-authentication header to the calculated value
    req.add_field("x-ni-authentication", authentication)
  end

  def create_request(uri, 
      method = "GET",
      data = nil)
      
    if(((method == "POST") || (method == "PUT")) && (data == nil))
      raise ArgumentError, "No postdata found for POST/PUT request"
    end
      
    url = URI.parse(uri)
      
    req = Net::HTTP::Get.new(url.path) if(method == "GET")
    req = Net::HTTP::Post.new(url.path) if(method == "POST")
    req = Net::HTTP::Put.new(url.path) if(method == "PUT")
    req = Net::HTTP::Delete.new(url.path) if(method == "DELETE")
    
    # If the server set a cookie in its last response, add the cookie to the 
    # headers of the current request
    cookieValue = @cookieHash.fetch(url.host + ":" + url.port.to_s, nil)
		req.add_field('set-cookie', cookieValue) if !cookieValue.nil?
    
    # Set content-type, content length and request body for POST and PUT requests
    if((method == "POST") || (method == "PUT"))
      req.content_type = "application/x-www-form-urlencoded"
      req.content_length = data.bytesize
      req.body = data
    end
    
    # Sign the request using the access_id and secret_id
    SignRequest(req) if(!secret_id.nil? && !access_id.nil?)
    
    resp = Net::HTTP.start(url.host, url.port) {|http|
      http.request(req)
    }
    
    # Store any cookies from the server in the cookie hash
    cookieValue = resp['set-cookie']
		@cookieHash[url.host + ":" + url.port] = cookieValue  if !cookieValue.nil?
    
    puts "Response Body: " + resp.body
  end
end

t_accessKey = "PqVr/ifkAQh+lVrdPIykXlFvg12GhhQFR8H9cUhphgg="
t_secretKey = "pTe9HRlQuMfJxAG6QCGq7UvoUpJzAzWGKy5SbZ+roSU="
t_data = "Test post data"

t_uri = "http://localhost/WebService/post"
x = LVWSClient.new(t_accessKey, t_secretKey)

puts "===" + t_uri + "==="
x.create_request(t_uri, "POST", t_data)

t_uri = "http://localhost/WebService/get/34/65"

puts "===" + t_uri + "==="
x.create_request(t_uri)

#t_uri = "http://localhost/WebService/put"
#puts "===" + t_uri + "==="
#x.create_request(t_uri, "PUT", t_data)
#t_uri = "http://localhost/WebService/delete"
#puts "===" + t_uri + "==="
#x.create_request(t_uri, "DELETE")
